<?php
/**
 * Pixflow
 */

pixflow_remove_param('vc_empty_space', 'el_class');

$empty_space_setting = array(
    'name' => esc_attr__("Empty Space", 'massive-dynamic'),
    'show_settings_on_create' => false,
    "category" => esc_attr__("Structure", 'massive-dynamic'),
);

pixflow_add_param("vc_empty_space", array(
    "type" => 'md_vc_slider',
    "weight" => "2",
    "heading" => esc_attr__("Height", 'massive-dynamic'),
    "param_name" => "height",
    "value" => "100",
    "edit_field_class" => $filedClass . "glue first last",
    'defaultSetting' => array(
        "min" => "0",
        "max" => "800",
        "prefix" => "px",
        "step" => '5',
    )
));




pixflow_add_param("vc_empty_space", array(
    "type" => 'md_vc_slider',
    "weight" => "2",
    "heading" => esc_attr__("Mobile Portrait Height", 'massive-dynamic'),
    "param_name" => "mobile_portrait_height",
    "value" => "-1",
    "edit_field_class" => $filedClass . "glue first last",
    'defaultSetting' => array(
        "min" => "0",
        "max" => "800",
        "prefix" => "px",
        "step" => '5',
    )
));


pixflow_add_param("vc_empty_space", array(
    "type" => 'md_vc_slider',
    "weight" => "2",
    "heading" => esc_attr__("Mobile Landscape Height", 'massive-dynamic'),
    "param_name" => "mobile_landscape_height",
    "value" => "-1",
    "edit_field_class" => $filedClass . "glue first last",
    'defaultSetting' => array(
        "min" => "0",
        "max" => "800",
        "prefix" => "px",
        "step" => '5',
    )
));


pixflow_add_param("vc_empty_space", array(
    "type" => 'md_vc_slider',
    "weight" => "2",
    "heading" => esc_attr__("Tablet Portrait Height", 'massive-dynamic'),
    "param_name" => "tablet_portrait_height",
    "value" => "-1",
    "edit_field_class" => $filedClass . "glue first last",
    'defaultSetting' => array(
        "min" => "0",
        "max" => "800",
        "prefix" => "px",
        "step" => '5',
    )
));

pixflow_add_param("vc_empty_space", array(
    "type" => 'md_vc_slider',
    "weight" => "2",
    "heading" => esc_attr__("Tablet Landscape Height", 'massive-dynamic'),
    "param_name" => "tablet_landscape_height",
    "value" => "-1",
    "edit_field_class" => $filedClass . "glue first last",
    'defaultSetting' => array(
        "min" => "0",
        "max" => "800",
        "prefix" => "px",
        "step" => '5',
    )
));



pixflow_add_param("vc_empty_space", array(
    "type" => "md_vc_checkbox",
    "edit_field_class" => $filedClass . "glue first last",
    "param_name" => "hide_in_responsive",
    "heading" => esc_attr__('Hide in Responsive Mode', 'massive-dynamic'),
    'value' => array(esc_attr__('No', 'massive-dynamic') => 'no'),
    'checked' => false,
));






pixflow_map_update('vc_empty_space', $empty_space_setting);
