<?php
/**
 * Pixflow
 */

/*-----------------------------------------------------------------------------------*/
/*  Modern Image Box Pro
/*-----------------------------------------------------------------------------------*/
global $separatorCounter;
$separatorCounter = 1;
pixflow_map(
    array(
        "name" => "Modern Image Box Pro",
        "base" => "md_modern_image_box_pro",
        "category" => esc_attr__('Media','massive-dynamic'),
        'show_settings_on_create' => false,
        "allowed_container_element" => 'vc_row',
        'show_settings_on_create' => false,
        "params" => array(
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "first glue",
                "heading" => esc_attr__("Icon Source", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_icon_source",
                "admin_label" => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("MD Icons", 'massive-dynamic') => "massive_dynamic",
                    esc_attr__("Custom Icon", 'massive-dynamic') => "custom",
                ),
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_icon_color_separator_" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "md_vc_iconpicker",
                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Choose an icon", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_icon",
                "value" => "icon-diamond",
                "admin_label" => false,
                "group" => esc_attr__("General", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_icon_source",
                    'value' => array('massive_dynamic')
                )
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_icon_color_separator_" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
                "admin_label" => false,
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_icon_source",
                    'value' => array('massive_dynamic')
                )
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Icon Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_icon_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_icon_source",
                    'value' => array('massive_dynamic')
                )
            ),
            array(
                'type' => 'attach_image',
                "edit_field_class" => $filedClass . "glue last",
                'heading' => esc_attr__('Choose Image', 'massive-dynamic'),
                'param_name' => 'md_modern_image_box_pro_icon_image',
                "group" => esc_attr__("General", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_icon_source",
                    'value' => array('custom')
                )
            ),
            array(
                "type" => "textarea",
                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Title", 'massive-dynamic'),
                "value" => "And We Blog Sometimes",
                "param_name" => "md_modern_image_pro_box_title",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "description" => esc_attr__("Image Box Modern Pro Heading Text", 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_separator_" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Title Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_title_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "textarea",
                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Description", 'massive-dynamic'),
                "value" => "No more fumbling to unlock your phone and find your notes app; Cheatsheet is as easy as pulling down center, pulling up the keyboard, or glancing at your Apple Watch.",
                "param_name" => "md_modern_image_box_pro_desc",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "description" => esc_attr__("Image Box Modern Pro Description", 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Description Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_desc_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "first glue",
                "heading" => esc_attr__("Background Type", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_background_type",
                "admin_label" => false,
                "group" => esc_attr__('General', 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Background Color", 'massive-dynamic') => "color",
                    esc_attr__("Background Image", 'massive-dynamic') => "image",
                ),
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                'type' => 'attach_image',
                "edit_field_class" => $filedClass . "glue",
                'heading' => esc_attr__('Background Image', 'massive-dynamic'),
                'param_name' => 'md_modern_image_box_pro_image',
                "group" => esc_attr__("General", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_background_type",
                    'value' => array('image')
                )
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_separator" . ++$separatorCounter,
                "group" => esc_attr__("General", 'massive-dynamic'),
            ),
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Overlay Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_image_hover_color",
                "value" => 'rgba(0,0,0,0.3)',
                "admin_label" => false,
                "opacity" => true,
                "group" => esc_attr__("General", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_background_type",
                    'value' => array('image')
                )
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Background Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_color",
                "value" => '#ffffff',
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_background_type",
                    'value' => array('color')
                )
            ),
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Image Height in Pixels", 'massive-dynamic'),
                "value" => "650",
                "param_name" => "md_modern_image_box_pro_image_height",
                "group" => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Add button  ', 'massive-dynamic'),
                'param_name' => 'md_modern_image_box_pro_button',
                "group" => esc_attr__('Button', 'massive-dynamic'),
                'value' => array(esc_attr__('Yes', 'massive-dynamic') => 'yes'),
                'checked' => true,
            ),//image box full add btn
            array(
                "type" => 'md_vc_separator',
                "edit_field_class" => $filedClass . "stick-to-top",
                "param_name" => "md_modern_image_box_pro_button_separator" . ++$separatorCounter,
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full separator
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue last",
                "separate" => true,
                "heading" => esc_attr__("Button Style", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_style",
                "description" => esc_attr__("Choose between five button style", 'massive-dynamic'),
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Slide", 'massive-dynamic') => "slide",
                    esc_attr__("Fade Square", 'massive-dynamic') => "fade-square",
                    esc_attr__("Fade Oval", 'massive-dynamic') => "fade-oval",

                    esc_attr__("Fill Slide", 'massive-dynamic') => "come-in",
                    esc_attr__("Animation", 'massive-dynamic') => "animation",
                    esc_attr__("Flash Animate", 'massive-dynamic') => "flash-animate",
                    esc_attr__("Fill Rectangle", 'massive-dynamic') => "fill-rectangle",
                    esc_attr__("Fill Oval", 'massive-dynamic') => "fill-oval"
                ),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full btn kind
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first",

                "heading" => esc_attr__("Button Text", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_text",
                "value" => "Read more",
                "description" => esc_attr__("Button text", 'massive-dynamic'),
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full btn text
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_button_text_separator" . ++$separatorCounter,
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full separator
            array(
                "type" => "md_vc_iconpicker",

                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Choose an icon", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_icon",
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "admin_label" => false,
                "description" => esc_attr__("Select an icon that shown before text", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                ),
                'value' => 'icon-arrow-right4'
            ),//image box full btn icon
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue first last",

                "heading" => esc_attr__("Button Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_color",
                "admin_label" => false,
                "opacity" => false,
                "value" => '#fff',
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => Array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                ),
                "description" => esc_attr__("Choose background color", 'massive-dynamic')
            ),//btn general color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "button_hover_color_separator". ++$separatorCounter,
                "edit_field_class" => $filedClass . "stick-to-top",
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('come-in', 'slide', 'fade-oval', 'fill-oval', 'fill-rectangle', 'fade-square'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Text Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_text_color",
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "admin_label" => false,
                "opacity" => true,
                "description" => esc_attr__("Enter optional button's color", 'massive-dynamic'),
                'value' => '#fff',
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//text color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "button_hover_color_separator". ++$separatorCounter,
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Bg Hover Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_bg_hover_color",
                "admin_label" => false,
                "description" => esc_attr__("Enter optional button hover's color", 'massive-dynamic'),
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
                'value' => '#9b9b9b'
            ),//bg hover color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_button_hover_color_separator". ++$separatorCounter,
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",

                "heading" => esc_attr__("Button Hover Color", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_hover_color",
                "admin_label" => false,
                "value" => '#9b9b9b',
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "md_modern_image_box_pro_button_style",
                    'value' => array('come-in', 'slide', 'fade-oval', 'fill-oval', 'fill-rectangle', 'fade-square'),
                ),
            ),//btn hover color
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first",

                "heading" => esc_attr__("Button Size", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_size",
                "admin_label" => false,
                "description" => esc_attr__("Choose size of your button", 'massive-dynamic'),
                "group" => esc_attr__("Button", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Standard", 'massive-dynamic') => "standard",
                    esc_attr__("Small", 'massive-dynamic') => "small"
                ),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                ),

            ),//size
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_button_size_separator". ++$separatorCounter,
                "admin_label" => false,
                "group" => esc_attr__("Button", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "imagebox_button",
                    'value' => array('yes')
                ),

            ),//separator
            array(
                'type' => 'md_vc_slider',
                "edit_field_class" => $filedClass . "glue last",
                'heading' => esc_attr__('Button Padding', 'massive-dynamic'),
                'param_name' => 'md_modern_image_box_pro_left_right_padding',
                "group" => esc_attr__("Button", 'massive-dynamic'),
                'value' => '0',
                'defaultSetting' => array(
                    "min" => "0",
                    "max" => "300",
                    "prefix" => " px",
                    "step" => "1",
                ),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                ),
            ),//space
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "glue first",

                "heading" => esc_attr__("Button Link", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_url",
                "value" => "#",
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                "description" => esc_attr__("Button destination URL", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full btn url
            array(
                "type" => 'md_vc_separator',
                "param_name" => "md_modern_image_box_pro_button_url_separator" . ++$separatorCounter,
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),//image box full separator
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue last",

                "heading" => esc_attr__("Link's target", 'massive-dynamic'),
                "param_name" => "md_modern_image_box_pro_button_target",
                "admin_label" => false,
                "group" => esc_attr__('Button', 'massive-dynamic'),
                "description" => esc_attr__("Open the link in the same tab or a blank browser tab", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Open in same window", 'massive-dynamic') => "_self",
                    esc_attr__("Open in new window", 'massive-dynamic') => "_blank"
                ),
                'dependency' => array(
                    'element' => "md_modern_image_box_pro_button",
                    'value' => array('yes')
                )
            ),////image box full btn target
        )
    )
);

pixflow_add_params('md_modern_image_box_pro', pixflow_addAnimationTab('md_modern_image_box_pro'));
