<?php
/**
 * Pixflow
 */


/*-----------------------------------------------------------------------------------*/
/*  Blog Masonry
/*-----------------------------------------------------------------------------------*/
$posts_cats = array();
$terms = get_terms('category', 'orderby=count&hide_empty=0');
if (!empty($terms) && !is_wp_error($terms)) {
    foreach ($terms as $term) {
        $posts_cats[] = $term->name;
    }
}


pixflow_map(
    array(
        'base' => 'md_blog_masonry',
        'name' => esc_attr__('Blog Masonry', 'massive-dynamic'),
        "show_settings_on_create" => false,
        "category" => esc_attr__('Media','massive-dynamic'),
        'params' => array(
            array(
                "type" => "md_group_title",
                "heading" => esc_attr__("Categories", 'massive-dynamic'),
                "param_name" => "category_group",
                'group' => esc_attr__('General', 'massive-dynamic'),
                "edit_field_class" => $filedClass . "glue first ",
            ),
            array(
                'type' => 'md_vc_multiselect',
                "edit_field_class" => $filedClass . "first glue",
                'heading' => esc_attr__('Category', 'massive-dynamic'),
                'param_name' => 'blog_category',
                'items' => $posts_cats,
                'defaults' => 'all',
                'group' => esc_attr__('General', 'massive-dynamic')
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_category_separator" . ++$separatorCounter,
                "admin_label" => false,
                'group' => esc_attr__('General', 'massive-dynamic')
            ),
            array(
                "type" => 'md_vc_slider',
                "heading" => esc_attr__("Post Number", 'massive-dynamic'),
                "param_name" => "blog_post_number",
                "value" => "5",
                "edit_field_class" => $filedClass . "glue last",
                'defaultSetting' => array(
                    "min" => "0",
                    "max" => "30",
                    "prefix" => "",
                    "step" => '1',
                ),
                'group' => esc_attr__('General', 'massive-dynamic')

            ),
            array(
                "type" => "md_group_title",
                "heading" => esc_attr__("appearance", 'massive-dynamic'),
                'group' => esc_attr__('General', 'massive-dynamic'),
                "param_name" => "app_group",
                "edit_field_class" => $filedClass . "glue first ",
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Column Number", 'massive-dynamic'),
                "param_name" => "blog_column",
                "group" => esc_attr__("General", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Three", 'massive-dynamic') => "three",
                    esc_attr__("Four", 'massive-dynamic') => "four",
                ),
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("Heading Tag", 'massive-dynamic'),
                "param_name" => "blog_post_title_heading",
                "group" => esc_attr__("General", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("H1", 'massive-dynamic') => "h1",
                    esc_attr__("H2", 'massive-dynamic') => "h2",
                    esc_attr__("H3", 'massive-dynamic') => "h3",
                    esc_attr__("H4", 'massive-dynamic') => "h4",
                    esc_attr__("H5", 'massive-dynamic') => "h5",
                    esc_attr__("H6", 'massive-dynamic') => "h6",
                ),
            ),
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue first",
                "heading" => esc_attr__("Background Color", 'massive-dynamic'),
                "param_name" => "blog_background_color",
                'group' => esc_attr__('General', 'massive-dynamic'),
                "value" => 'rgb(87,63,203)',
                "admin_label" => false,
                "opacity" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_background_color_separator" . ++$separatorCounter,
                'group' => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Text Color", 'massive-dynamic'),
                "param_name" => "blog_foreground_color",
                'group' => esc_attr__('General', 'massive-dynamic'),
                "value" => 'rgb(255,255,255)',
                "admin_label" => false,
                "opacity" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_foreground_color_separator" . ++$separatorCounter,
                'group' => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue ",
                "heading" => esc_attr__("Accent Color", 'massive-dynamic'),
                "param_name" => "blog_accent_color",
                'group' => esc_attr__('General', 'massive-dynamic'),
                "value" => 'rgb(220,38,139)',
                "admin_label" => false,
                "opacity" => false,
            ), array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_accent_color_separator" . ++$separatorCounter,
                'group' => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ),
            array(
                "type" => "md_vc_colorpicker",
                'group' => esc_attr__('General', 'massive-dynamic'),
                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Text Accent Color", 'massive-dynamic'),
                "param_name" => "blog_text_accent_color",
                "value" => 'rgb(0,0,0)',
                "admin_label" => false,
                "opacity" => false,
            ),
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_accent_color_separator" . ++$separatorCounter,
                'group' => esc_attr__('General', 'massive-dynamic'),
                "admin_label" => false,
            ), array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Shadow Color", 'massive-dynamic'),
                'group' => esc_attr__('General', 'massive-dynamic'),
                "param_name" => "blog_post_shadow",
                "value" => 'rgba(0,0,0,.12)',
                "admin_label" => false,
                "opacity" => true,
            ),
            array(
                'type' => 'md_vc_checkbox',
                "edit_field_class" => $filedClass . "glue first last",
                'heading' => esc_attr__('Load More Button', 'massive-dynamic'),
                'param_name' => 'blog_load_more',
                'group' => esc_attr__("General", 'massive-dynamic'),
                'value' => array(esc_attr__('No', 'massive-dynamic') => 'no'),
                'checked' => false,
            ),//add btn
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_separator" . ++$separatorCounter,
                "edit_field_class" => $filedClass . "stick-to-top",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "admin_label" => false,
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//separator
            array(
                "type" => "md_group_title",
                "heading" => esc_attr__("Style", 'massive-dynamic'),
                "param_name" => "btn_style_group",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "edit_field_class" => $filedClass . "glue first last",
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue last",
                "separate" => true,
                "heading" => esc_attr__("Button Style", 'massive-dynamic'),
                "param_name" => "blog_button_style",
                "description" => esc_attr__("Choose between five button style", 'massive-dynamic'),
                "admin_label" => false,
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "value" => array(
                    esc_attr__("Fade Square", 'massive-dynamic') => "fade-square",
                    esc_attr__("Fade Oval", 'massive-dynamic') => "fade-oval",
                    esc_attr__("Slide", 'massive-dynamic') => "slide",
                    esc_attr__("Fill Slide", 'massive-dynamic') => "come-in",
                    esc_attr__("Animation", 'massive-dynamic') => "animation",
                    esc_attr__("Flash Animate", 'massive-dynamic') => "flash-animate",
                    esc_attr__("Fill Rectangle", 'massive-dynamic') => "fill-rectangle",
                    esc_attr__("Fill Oval", 'massive-dynamic') => "fill-oval"
                ),
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//btn kind
            array(
                "type" => "dropdown",
                "edit_field_class" => $filedClass . "glue last first",
                "heading" => esc_attr__("Size", 'massive-dynamic'),
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "param_name" => "blog_button_size",
                "admin_label" => false,
                "value" => array(
                    esc_attr__("Standard", 'massive-dynamic') => "standard",
                    esc_attr__("Small", 'massive-dynamic') => "small"
                ),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//btn size
            array(
                'type' => 'md_vc_slider',
                "edit_field_class" => $filedClass . "glue last first",
                'heading' => esc_attr__('Padding', 'massive-dynamic'),
                'param_name' => 'blog_button_padding',
                'value' => '0',
                "group" => esc_attr__("Load More Button", 'massive-dynamic'),
                'defaultSetting' => array(
                    "min" => "0",
                    "max" => "300",
                    "prefix" => " px",
                    "step" => "1",
                ),
                "dependency" => array(
                    'element' => "blog_load_more",
                    'value' => array('yes')
                )
            ),//btn space
            array(
                "type" => "md_group_title",
                "heading" => esc_attr__("Content", 'massive-dynamic'),
                "param_name" => "btn_content_group",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "edit_field_class" => $filedClass . "glue first last",
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),
            array(
                "type" => "textfield",
                "edit_field_class" => $filedClass . "last first glue",
                "heading" => esc_attr__("Text", 'massive-dynamic'),
                "param_name" => "blog_button_text",
                "description" => esc_attr__("Button text", 'massive-dynamic'),
                "admin_label" => false,
                "value" => 'LOAD MORE',
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//btn text

            array(
                "type" => "md_vc_iconpicker",
                "edit_field_class" => $filedClass . "glue last first",
                "heading" => esc_attr__("Choose an icon", 'massive-dynamic'),
                "param_name" => "blog_button_icon_class",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "admin_label" => false,
                "description" => esc_attr__("Select an icon that shown before text", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                ),
                'value' => 'icon-plus6'
            ),//btn icon
            array(
                "type" => "md_group_title",
                "heading" => esc_attr__("Appearance", 'massive-dynamic'),
                "param_name" => "btn_app_group",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "edit_field_class" => $filedClass . "glue first last",
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),
            array(
                "type" => "md_vc_colorpicker",
                "edit_field_class" => $filedClass . "glue first last",
                "heading" => esc_attr__("General Color", 'massive-dynamic'),
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "param_name" => "blog_button_color",
                "admin_label" => false,
                "opacity" => true,
                "value" => "rgba(0,0,0,1)",
                "description" => esc_attr__("Enter optional button's color", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//general color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "button_hover_color_separator" . ++$separatorCounter,
                "edit_field_class" => $filedClass . "stick-to-top",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('come-in', 'slide', 'fade-oval', 'fill-oval', 'fill-rectangle', 'fade-square'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Text Color", 'massive-dynamic'),
                "param_name" => "blog_button_text_color",
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "admin_label" => false,
                "opacity" => true,
                "description" => esc_attr__("Enter optional button's color", 'massive-dynamic'),
                'value' => '#fff',
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//text color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "button_hover_color_separator" . ++$separatorCounter,
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue",
                "heading" => esc_attr__("Bg Hover Color", 'massive-dynamic'),
                "param_name" => "blog_button_bg_hover_color",
                "admin_label" => false,
                "description" => esc_attr__("Enter optional button hover's color", 'massive-dynamic'),
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
                'value' => '#9b9b9b'
            ),//bg hover color
            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_button_color_separator" . ++$separatorCounter,
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('fill-oval', 'fill-rectangle'),
                ),
            ),//separator
            array(
                "type" => "md_vc_colorpicker",

                "edit_field_class" => $filedClass . "glue last",
                "heading" => esc_attr__("Text Hover Color", 'massive-dynamic'),
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                "param_name" => "blog_button_hover_color",
                "admin_label" => false,
                "value" => "rgb(255,255,255)",
                "description" => esc_attr__("Enter optional button hover's color", 'massive-dynamic'),
                "dependency" => array(
                    'element' => "blog_button_style",
                    'value' => array('come-in', 'slide', 'fade-oval', 'fill-oval', 'fill-rectangle', 'fade-square'),
                ),

            ),//text hover color

            array(
                "type" => 'md_vc_separator',
                "param_name" => "blog_button_hover_color_separator" . ++$separatorCounter,
                'group' => esc_attr__("Load More Button", 'massive-dynamic'),
                'dependency' => array(
                    'element' => "blog_load_more",
                    'value' => array('yes'),
                )
            ),//separator

            array(
                "type" => "md_vc_description",
                "param_name" => "blog_item_number_description",
                "admin_label" => false,
                "group" => esc_attr__("Load More Button", 'massive-dynamic'),
                "value" => '<ul><li>' . esc_attr__('Please note that Load More functionality does not work in builder view for technical reasons.', 'massive-dynamic') . '</li></ul>',
            ),
        )
    )
);

pixflow_add_params('md_blog_masonry', pixflow_addAnimationTab('md_blog_masonry'));
