<?php
function px_generate_column_css($atts){

    ?>
    <style>



        @media (max-width: 600px) and (orientation: portrait){


            .layout-container .layout  .vc_column_container .<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_mobile_portrait_margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_mobile_portrait_padding'],'!important'); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_mobile_portrait_visibility'])== 'true'  || $atts['md_mobile_portrait_visibility']== 'enable' || $atts['md_mobile_portrait_visibility']== 'yes' ? 'inherit;' :  'none !important;' ?>
            }
        }

        @media (max-width: 850px) and (orientation: landscape){

            .layout-container .layout  .vc_column_container .<?php echo esc_attr($atts['id']) ?>{

                <?php px_generate_separate_property("margin",$atts['md_mobile_landscape_margin']); ?>
                <?php px_generate_separate_property("padding",$atts['md_mobile_landscape_padding'],'!important'); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_mobile_landscape_visibility'])== 'true' || $atts['md_mobile_landscape_visibility']== 'enable' || $atts['md_mobile_landscape_visibility']== 'yes' ? 'inherit;' :  'none !important;' ?>
                <?php
                    switch ($atts['md_mobile_landscape_width']) {
                        case "6":
                            echo "width:50%;float:left;";
                            break;
                        case "12":
                            echo "width:100%;float:none;clear:both;";
                            break;
                    }
                ?>
            }
        }


        @media (min-width:600px) and (max-width: 1024px) and (orientation: portrait){
            .layout-container .layout  .vc_column_container .<?php echo esc_attr($atts['id']) ?>{
                <?php px_generate_separate_property("margin",$atts['md_tablet_portrait_margin']); ?>
                <?php px_generate_separate_property("padding",$atts['md_tablet_portrait_padding'],"!important"); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_tablet_portrait_visibility'])== 'true'  || $atts['md_tablet_portrait_visibility']== 'enable' || $atts['md_tablet_portrait_visibility']== 'yes'  ? 'inherit;' :  'none !important;' ?>
                <?php
                    switch ($atts['md_tablet_portrait_width']) {
                        case "6":
                            echo "width:50%;float:left;";
                            break;
                        case "12":
                            echo "width:100%;float:none;clear:both;";
                            break;
                    }
                ?>
            }
        }


        @media (min-width:850px) and (max-width: 1280px) and (orientation: landscape){
            .layout-container .layout  .vc_column_container .<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_tablet_landscape_margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_tablet_landscape_padding'],"!important"); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_tablet_landscape_visibility'])== 'true' || $atts['md_tablet_landscape_visibility']== 'enable' || $atts['md_tablet_landscape_visibility']== 'yes' ? 'inherit !important;' :  'none !important;' ?>
                <?php
                    switch ($atts['md_tablet_landscape_width']) {
                        case "6":
                            echo "width:50%;float:left;";
                            break;
                        case "12":
                            echo "width:100%;float:none;clear:both;";
                            break;
                    }
                ?>
            }
        }


        @media (min-width:1280px) and (max-width:1680px) {


            body:not(.compose-mode) .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_laptop_visibility'])== 'true' || $atts['md_laptop_visibility']== 'enable' || $atts['md_laptop_visibility']== 'yes' ? 'inherit;' :  'none !important;' ?>
                 <?php
                    switch ($atts['md_laptop_width']) {
                        case "6":
                            echo "width:50%;float:left;";
                            break;
                        case "12":
                            echo "width:100%;float:none;clear:both;";
                            break;
                    }
                ?>
            }

        }
    </style>



<?php }



function px_generate_row_css($atts){
?>
 <style>



        @media (max-width: 600px) and (orientation: portrait){
            .layout-container .layout  #<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_mobile_portrait_margin'],'!important',$atts['current-margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_mobile_portrait_padding'],'!important',$atts['current-padding']); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_mobile_portrait_visibility'])== 'true'  || $atts['md_mobile_portrait_visibility']== 'enable' || $atts['md_mobile_portrait_visibility']== 'yes' ? 'inherit;' :  'none !important;' ?>
            }
        }

        @media (max-width: 850px) and (orientation: landscape){
            .layout-container .layout  #<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_mobile_landscape_margin'],'!important',$atts['current-margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_mobile_landscape_padding'],'!important',$atts['current-padding']); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_mobile_landscape_visibility'])== 'true'  || $atts['md_mobile_landscape_visibility']== 'enable' || $atts['md_mobile_landscape_visibility']== 'yes' ? 'inherit' :  'none !important;' ?>
            }

        }


        @media (min-width:600px) and (max-width: 1024px) and (orientation: portrait){
            .layout-container .layout  #<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_tablet_portrait_margin'],'!important',$atts['current-margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_tablet_portrait_padding'],'!important',$atts['current-padding']); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_tablet_portrait_visibility'])== 'true'  || $atts['md_tablet_portrait_visibility']== 'enable' || $atts['md_tablet_portrait_visibility']== 'yes' ? 'inherit' :  'none !important;' ?>
            }
        }


        @media (min-width:850px) and (max-width: 1280px) and (orientation: landscape){
            .layout-container .layout  #<?php echo esc_attr($atts['id']) ?>{
            <?php px_generate_separate_property("margin",$atts['md_tablet_landscape_margin'],'!important',$atts['current-margin']); ?>
            <?php px_generate_separate_property("padding",$atts['md_tablet_landscape_padding'],'!important',$atts['current-padding']); ?>
            }

            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_tablet_landscape_visibility'])== 'true'  || $atts['md_tablet_landscape_visibility']== 'enable' || $atts['md_tablet_landscape_visibility']== 'yes' ? 'inherit' :  'none !important;' ?>
            }
        }

        @media (min-width:1280px) and (max-width:1680px) {
            .layout-container .layout #<?php echo esc_attr($atts['id']) ?>{
                display:<?php echo esc_attr($atts['md_laptop_visibility'])== 'true'  || $atts['md_laptop_visibility']== 'enable' || $atts['md_laptop_visibility']== 'yes' ? 'flex' :  'none !important;' ?>
            }
        }
    </style>

    <?php



}



function  px_generate_image_box_responsive_css($attr){
    ?>

    <style>
        @media (max-width: 600px) and (orientation: portrait) {

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul,
        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul>li{
           <?php if($attr['image_box_slider_mobile_portrait_height'] != ''){
               echo ("height:{$attr['image_box_slider_mobile_portrait_height']}px  !important;");
               echo ("max-height:{$attr['image_box_slider_mobile_portrait_height']}px  !important;");
           } ?>
       }

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider .imgBox-image{
             <?php if($attr['image_box_slider_mobile_portrait_size'] != ''){
                 echo ("background-size:{$attr['image_box_slider_mobile_portrait_size']} !important;");
             } ?>
         }

        }


        @media (max-width: 850px) and (orientation: landscape) {

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul,#<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul>li{
           <?php if($attr['image_box_slider_mobile_landscape_height'] != ''){
               echo ("height:{$attr['image_box_slider_mobile_landscape_height']}px  !important;");
               echo ("max-height:{$attr['image_box_slider_mobile_landscape_height']}px  !important;");
           } ?>
        }

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider .imgBox-image{
         <?php if($attr['image_box_slider_mobile_landscape_size'] != ''){
             echo ("background-size:{$attr['image_box_slider_mobile_landscape_size']} !important;");
         } ?>
         }
        }



        @media (min-width:600px) and (max-width: 1024px) and (orientation: portrait) {
        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul,#<?php echo(esc_attr($attr['id'])) ?>.img-box-slider ul>li{
                                                       <?php if($attr['image_box_slider_tablet_portrait_height'] != ''){
                                                           echo ("height:{$attr['image_box_slider_tablet_portrait_height']}px  !important;");
                                                           echo ("max-height:{$attr['image_box_slider_tablet_portrait_height']}px  !important;");
                                                       } ?>
                                                       }

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider .imgBox-image{
         <?php if($attr['image_box_slider_tablet_portrait_size'] != ''){
             echo ("background-size:{$attr['image_box_slider_tablet_portrait_size']} !important;");
         } ?>
         }
        }




        @media (min-width:850px) and (max-width: 1280px) and (orientation: landscape) {
        #<?php echo($attr['id']) ?>.img-box-slider ul,#<?php echo($attr['id']) ?>.img-box-slider ul>li{
       <?php if($attr['image_box_slider_tablet_landscape_height'] != ''){
           echo ("height:{$attr['image_box_slider_tablet_landscape_height']}px  !important;");
           echo ("max-height:{$attr['image_box_slider_tablet_landscape_height']}px  !important;");
       } ?>
       }

        #<?php echo(esc_attr($attr['id'])) ?>.img-box-slider .imgBox-image{
         <?php if($attr['image_box_slider_tablet_landscape_size'] != ''){
             echo ("background-size:{$attr['image_box_slider_tablet_landscape_size']} !important;");
         } ?>
         }

        }



    </style>

<?php }



function px_general_responsive_functions(){
    $laptop_container_width_enable=  esc_attr(pixflow_get_theme_mod('mainC-width-laptop-enable', 1));
    if($laptop_container_width_enable){
        $laptop_container_width=esc_attr(pixflow_get_theme_mod('mainC-width-laptop', '80')."%");
    }else{
        $laptop_container_width=esc_attr(pixflow_get_theme_mod('mainC-width', '80')."%");
    }

    $tablet_container_width_enable=  esc_attr(pixflow_get_theme_mod('mainC-width-tablet-enable', 1));
    if($tablet_container_width_enable){
        $tablet_container_width=esc_attr(pixflow_get_theme_mod('mainC-width-tablet', PIXFLOW_MAINC_WIDTH_TABLET)."%");
    }else{
        $tablet_container_width=esc_attr(pixflow_get_theme_mod('mainC-width', PIXFLOW_MAINC_WIDTH)."%");
    }

    ?>


    <style>

        @media (max-width: 600px) and (orientation: portrait) {



            .md-text-alignment-mobile-portrait-right .md-text-content,
            .md-text-alignment-mobile-portrait-right .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-portrait-right .md-text-title,
            .layout .md-text-alignment-mobile-portrait-right .md-text-button{
                text-align: right !important;
            }


            .layout .md-text-alignment-mobile-portrait-right .md-text-title-separator {
                margin-left: auto !important;
                margin-right: 0 !important;
            }


            .md-text-alignment-mobile-portrait-left .md-text-content,
            .md-text-alignment-mobile-portrait-left .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-portrait-left .md-text-title,
            .layout .md-text-alignment-mobile-portrait-left .md-text-button {
                text-align: left !important;
            }

            .layout .md-text-alignment-mobile-portrait-left .md-text-title-separator {
                margin-left: 0 !important;
                margin-right: auto !important;
            }


            .md-text-alignment-mobile-portrait-center .md-text-content,
            .md-text-alignment-mobile-portrait-center .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-portrait-center .md-text-title,
            .layout .md-text-alignment-mobile-portrait-center .md-text-button {
                text-align: center !important;
            }

            .layout .md-text-alignment-mobile-portrait-center .md-text-title-separator {
                margin-left: auto !important;
                margin-right: auto !important;
            }






            .px-mobile-portrait-align-right  {
                display: flex;
                justify-content: flex-end;
            }

            .px-mobile-portrait-align-center  {
                display: flex;
                justify-content: center;
            }

            .px-mobile-portrait-align-left  {
                display: flex;
                justify-content: flex-start;
            }

            .px-mobile-portrait-align-right .px-svg-container,
            .px-mobile-portrait-align-left .px-svg-container{
                margin: 0 !important;
            }


            .layout .icon-box-mobile-portrait-left img.md-icon-box-image {
                float: left !important;
                display: block;
                clear: both;
                margin: 0px auto !important;
            }

            .layout .icon-box-mobile-portrait-center img.md-icon-box-image {
                float: none !important;
                display: block;
                clear: both;
                margin: 15px auto !important;
            }

            .layout .icon-box-mobile-portrait-right img.md-icon-box-image {
                float: right !important;
                display: block;
                clear: both;
                margin: 0px auto !important;
            }

        }


        @media (max-width: 850px) and (orientation: landscape) {

            .md-text-alignment-mobile-landscape-right .md-text-content,
            .md-text-alignment-mobile-landscape-right .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-landscape-right .md-text-title{
                text-align: right !important;
            }


            .layout .md-text-alignment-mobile-landscape-right .md-text-title-separator {
                margin-left: auto !important;
                margin-right: 0 !important;
            }

            .layout .md-text-alignment-mobile-landscape-right .md-text-button {
                text-align: right !important;
            }


            .md-text-alignment-mobile-landscape-left .md-text-content,
            .md-text-alignment-mobile-landscape-left .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-landscape-left .md-text-title{
                text-align: left !important;
            }

            .layout .md-text-alignment-mobile-landscape-left .md-text-title-separator {
                margin-left: 0 !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-mobile-landscape-left .md-text-button {
                text-align: left !important;
            }


            .md-text-alignment-mobile-landscape-center .md-text-content,
            .md-text-alignment-mobile-landscape-center .md-text-title.inline-editor-title,
            .md-text-alignment-mobile-landscape-center .md-text-title{
                text-align: center !important;
            }

            .layout .md-text-alignment-mobile-landscape-center .md-text-title-separator {
                margin-left: auto !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-mobile-landscape-center .md-text-button {
                text-align: center !important;
            }




            .px-mobile-landscape-align-right  {
                display: flex;
                justify-content: flex-end;
            }

            .px-mobile-landscape-align-center  {
                display: flex;
                justify-content: center;
            }

            .px-mobile-landscape-align-left  {
                display: flex;
                justify-content: flex-start;
            }

            .px-mobile-landscape-align-right .px-svg-container,
            .px-mobile-landscape-align-left .px-svg-container{
                margin: 0 !important;
            }


            .layout .icon-box-mobile-landscape-left img.md-icon-box-image {
                float: left !important;
                display: inline-block;
                clear: none;
                margin: 0px 15px 0 auto !important;
            }

            .layout .icon-box-mobile-landscape-left .iconbox-side-container {
                max-width: 90% !important;
                text-align: left !important;
            }


            .layout .icon-box-mobile-landscape-right img.md-icon-box-image {
                float: right !important;
                display: inline-block;
                clear: none;
                margin: 0px auto 0 15px !important;
            }

            .layout .icon-box-mobile-landscape-right .iconbox-side-container {
                max-width: 90% !important;
                text-align: right !important;
            }

            .layout .icon-box-mobile-landscape-center img.md-icon-box-image {
                float: none !important;
                display: block;
                clear: both;
                margin: 15px auto !important;
            }







        }



        @media (min-width:600px) and (max-width: 1024px) and (orientation: portrait) {

            .md-text-alignment-tablet-portrait-right .md-text-content,
            .md-text-alignment-tablet-portrait-right .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-portrait-right .md-text-title {
                text-align: right !important;
            }


            .layout .md-text-alignment-tablet-portrait-right .md-text-title-separator {
                margin-left: auto !important;
                margin-right: 0 !important;
            }

            .layout .md-text-alignment-tablet-portrait-right .md-text-button {
                text-align: right !important;
            }


            .md-text-alignment-tablet-portrait-left .md-text-content,
            .md-text-alignment-tablet-portrait-left .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-portrait-left .md-text-title{
                text-align: left !important;
            }

            .layout .md-text-alignment-tablet-portrait-left .md-text-title-separator {
                margin-left: 0 !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-tablet-portrait-left .md-text-button {
                text-align: left !important;
            }


            .md-text-alignment-tablet-portrait-center .md-text-content,
            .md-text-alignment-tablet-portrait-center .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-portrait-center .md-text-title {
                text-align: center !important;
            }

            .layout .md-text-alignment-tablet-portrait-center .md-text-title-separator {
                margin-left: auto !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-tablet-portrait-center .md-text-button {
                text-align: center !important;
            }







            .px-tablet-portrait-align-right  {
                display: flex;
                justify-content: flex-end;
            }

            .px-tablet-portrait-align-center  {
                display: flex;
                justify-content: center;
            }

            .px-tablet-portrait-align-left  {
                display: flex;
                justify-content: flex-start;
            }

            .px-tablet-portrait-align-right .px-svg-container,
            .px-tablet-portrait-align-left .px-svg-container{
                margin: 0 !important;
            }


            .icon-box-tablet-portrait-center .description {
                text-align: center !important;
            }



            .layout .icon-box-tablet-portrait-left img.md-icon-box-image {
                float: left !important;
                display: inline-block;
                clear: none;
                margin: 0px 15px 0 auto !important;
            }

            .layout .icon-box-tablet-portrait-left .iconbox-side-container {
                max-width: 90% !important;
                text-align: left !important;
            }


            .layout .icon-box-tablet-portrait-right img.md-icon-box-image {
                float: right !important;
                display: inline-block;
                clear: none;
                margin: 0 auto 0 15px !important;
            }

            .layout .icon-box-tablet-portrait-right .iconbox-side-container {
                max-width: 90% !important;
                text-align: right !important;
            }

            .layout .icon-box-tablet-portrait-center img.md-icon-box-image {
                float: none !important;
                display: block;
                clear: both;
                margin: 15px auto !important;
            }

        }




        @media (min-width:850px) and (max-width: 1280px) and (orientation: landscape) {

            .md-text-container.md-align-left.md-text-alignment-tablet-landscape-center,
            .md-text-container.md-align-right.md-text-alignment-tablet-landscape-center{
                justify-content: center;
            }


            .md-text-alignment-tablet-landscape-right .md-text-content,
            .md-text-alignment-tablet-landscape-right .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-landscape-right .md-text-title {
                text-align: right !important;
            }


            .layout .md-text-alignment-tablet-landscape-right .md-text-title-separator {
                margin-left: auto !important;
                margin-right: 0 !important;
            }

            .layout .md-text-alignment-tablet-landscape-right .md-text-button {
                text-align: right;
            }


            .md-text-alignment-tablet-landscape-left .md-text-content,
            .md-text-alignment-tablet-landscape-left .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-landscape-left .md-text-title {
                text-align: left !important;
            }

            .layout .md-text-alignment-tablet-landscape-left .md-text-title-separator {
                margin-left: 0 !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-tablet-landscape-left .md-text-button {
                text-align: left;
            }


            .md-text-alignment-tablet-landscape-center .md-text-content,
            .md-text-alignment-tablet-landscape-center .md-text-title.inline-editor-title,
            .md-text-alignment-tablet-landscape-center .md-text-title {
                text-align: center !important;
            }

            .layout .md-text-alignment-tablet-landscape-center .md-text-title-separator {
                margin-left: auto !important;
                margin-right: auto !important;
            }

            .layout .md-text-alignment-tablet-landscape-center .md-text-button {
                text-align: center;
            }


            .px-tablet-landscape-align-right {
                display: flex;
                justify-content: flex-end;
            }

            .px-tablet-landscape-align-center {
                display: flex;
                justify-content: center;
            }

            .px-tablet-landscape-align-left {
                display: flex;
                justify-content: flex-start;
            }

            .px-tablet-landscape-align-right .px-svg-container,
            .px-tablet-landscape-align-left .px-svg-container {
                margin: 0 !important;
            }

            .layout .icon-box-tablet-landscape-left img.md-icon-box-image {
                float: left !important;
                display: inline-block;
                clear: none;
                margin: 0px 15px 0 auto !important;
            }

            .layout .icon-box-tablet-landscape-left .iconbox-side-container {
                max-width: 90% !important;
                text-align: left !important;
                margin-left: 0;
            }


            .layout .icon-box-tablet-landscape-right img.md-icon-box-image {
                float: right !important;
                display: inline-block;
                clear: none;
                margin: 0px auto 0 15px !important;
            }

            .layout .icon-box-tablet-landscape-right .iconbox-side-container {
                max-width: 90% !important;
                text-align: right !important;
            }

            .layout .icon-box-tablet-landscape-center img.md-icon-box-image {
                float: none !important;
                display: block;
                clear: both;
                margin: 15px auto !important;
            }

            .layout .icon-box-tablet-landscape-center .iconbox-side-container {
                max-width: 100% !important;
                text-align: center !important;
                width:100%;
            }

            .iconbox-side.icon-box-tablet-landscape-center .icon-container,
            .iconbox-side.icon-box-tablet-landscape-center .iconbox-side-container {
                text-align: center !important;
                float: none;
            }

            .col-sm-8 .md-text-container ,
            .col-sm-7 .md-text-container ,
            .col-sm-6 .md-text-container ,
            .col-sm-5 .md-text-container,
            .col-sm-3 .md-text-container{
                max-width: 96%;
            }

        }





        @media screen
        and (min-device-width: 1024px)
        and (max-device-width: 1280px) {
            .layout-container .layout .sectionOverlay .box_size_container {
                width: <?php echo esc_attr($tablet_container_width);  ?> !important;
            }

            .col-sm-8 .md-text-container ,
            .col-sm-7 .md-text-container ,
            .col-sm-6 .md-text-container ,
            .col-sm-5 .md-text-container,
            .col-sm-3 .md-text-container{
                max-width: 96%;
            }


        }



        @media screen
        and (min-device-width: 1281px)
        and (max-device-width: 1680px) {
            .layout-container .layout .sectionOverlay .box_size_container,
            .layout-container .layout .sectionOverlay.box_size {
                width: <?php echo esc_attr($laptop_container_width);  ?> !important;
            }


        }




















    </style>


<?php }


add_action('wp_head', 'px_general_responsive_functions', 100);



function px_generate_separate_property($property,$att,$postfix='',$previous_values=[],$element_type='row'){
    if($att==''){
        if(sizeof($previous_values)<1){
            $result = array("0","0","0","0");
        }else{
            $result = array($previous_values[0].'px','0',$previous_values[1].'px','0');
        }
    }else{
        if(sizeof($previous_values)<1){
            $defaults = array("0","0","0","0");
        }else{
            if($element_type=='row'){
                $defaults = array($previous_values[0].'px','0',$previous_values[1].'px','0');
            }else {
                $defaults = array($previous_values[0].'px',$previous_values[1].'px',$previous_values[2].'px',$previous_values[3].'px');
            }

        }
        $arr=explode(" ",trim($att));
        $result=array_merge($arr,$defaults);

    }
    echo "$property-top : $result[0] $postfix;$property-right : $result[1] $postfix;$property-bottom : $result[2] $postfix;$property-left : $result[3] $postfix;";
}






function px_empty_space_responsive($id,$atts){
    ?>
    <style>



        @media (max-width: 600px) and (orientation: portrait){
            .<?php echo $id ?>{
                height: <?php echo esc_attr($atts['mobile_portrait_height'])==''?$atts['height']:$atts['mobile_portrait_height'] ?>px !important;
            }

            .hide-in-responsive-mode{
                display: none ;
            }
        }

        @media (max-width: 850px) and (orientation: landscape){
            .<?php echo $id ?>{
                height: <?php echo esc_attr($atts['mobile_landscape_height'])==''?$atts['height']:$atts['mobile_landscape_height'] ?>px !important;
            }

            .hide-in-responsive-mode{
                display: none;
            }
        }


        @media (min-width:600px) and (max-width: 1024px) and (orientation: portrait){
            .<?php echo $id ?>{
                height: <?php echo esc_attr($atts['tablet_portrait_height'])==''?$atts['height']:$atts['tablet_portrait_height'] ?>px !important;
            }

            .hide-in-responsive-mode{
                display: none;
            }
        }


        @media (min-width:850px) and (max-width: 1280px) and (orientation: landscape){
            .<?php echo $id ?>{
                height: <?php echo esc_attr($atts['tablet_landscape_height'])==''?$atts['height']:$atts['tablet_landscape_height'] ?>px !important;
            }
            .hide-in-responsive-mode{
                display: none;
            }
        }
    </style>



    <?php




}
