<?php
/**
 * CampaignsApi
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Moosend API
 *
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\Configuration;
use \Swagger\Client\ObjectSerializer;

/**
 * CampaignsApi Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CampaignsApi
{
    /**
     * API Client
     *
     * @var \Swagger\Client\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Swagger\Client\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Swagger\Client\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Swagger\Client\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Swagger\Client\ApiClient $apiClient set the API client
     *
     * @return CampaignsApi
     */
    public function setApiClient(\Swagger\Client\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation aBTestCampaignSummary
     *
     * AB Test Campaign Summary
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested AB test campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\AbTestCampaignSummaryResponse
     */
    public function aBTestCampaignSummary($format, $apikey, $campaign_id)
    {
        list($response) = $this->aBTestCampaignSummaryWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation aBTestCampaignSummaryWithHttpInfo
     *
     * AB Test Campaign Summary
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested AB test campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\AbTestCampaignSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function aBTestCampaignSummaryWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling aBTestCampaignSummary');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling aBTestCampaignSummary');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling aBTestCampaignSummary');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/view_ab_summary.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\AbTestCampaignSummaryResponse',
                '/campaigns/{CampaignID}/view_ab_summary.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\AbTestCampaignSummaryResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\AbTestCampaignSummaryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation activityByLocation
     *
     * Activity By Location
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\ActivityByLocationResponse
     */
    public function activityByLocation($format, $apikey, $campaign_id)
    {
        list($response) = $this->activityByLocationWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation activityByLocationWithHttpInfo
     *
     * Activity By Location
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\ActivityByLocationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function activityByLocationWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling activityByLocation');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling activityByLocation');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling activityByLocation');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/stats/countries.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\ActivityByLocationResponse',
                '/campaigns/{CampaignID}/stats/countries.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\ActivityByLocationResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\ActivityByLocationResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation campaignSummary
     *
     * Campaign Summary
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\CampaignSummaryResponse
     */
    public function campaignSummary($format, $apikey, $campaign_id)
    {
        list($response) = $this->campaignSummaryWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation campaignSummaryWithHttpInfo
     *
     * Campaign Summary
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\CampaignSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function campaignSummaryWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling campaignSummary');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling campaignSummary');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling campaignSummary');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/view_summary.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CampaignSummaryResponse',
                '/campaigns/{CampaignID}/view_summary.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CampaignSummaryResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CampaignSummaryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation cloningAnExistingCampaign
     *
     * Cloning An Existing Campaign
     *
     * @param string $format  (required)
     * @param string $campaign_id  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\CloningAnExistingCampaignResponse
     */
    public function cloningAnExistingCampaign($format, $campaign_id, $apikey)
    {
        list($response) = $this->cloningAnExistingCampaignWithHttpInfo($format, $campaign_id, $apikey);
        return $response;
    }

    /**
     * Operation cloningAnExistingCampaignWithHttpInfo
     *
     * Cloning An Existing Campaign
     *
     * @param string $format  (required)
     * @param string $campaign_id  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\CloningAnExistingCampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cloningAnExistingCampaignWithHttpInfo($format, $campaign_id, $apikey)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling cloningAnExistingCampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling cloningAnExistingCampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling cloningAnExistingCampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/clone.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CloningAnExistingCampaignResponse',
                '/campaigns/{CampaignID}/clone.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CloningAnExistingCampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CloningAnExistingCampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation creatingADraftCampaign
     *
     * Creating A Draft Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\CreatingADraftCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\CreatingADraftCampaignResponse
     */
    public function creatingADraftCampaign($format, $apikey, $body)
    {
        list($response) = $this->creatingADraftCampaignWithHttpInfo($format, $apikey, $body);
        return $response;
    }

    /**
     * Operation creatingADraftCampaignWithHttpInfo
     *
     * Creating A Draft Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param \Swagger\Client\Model\CreatingADraftCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\CreatingADraftCampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function creatingADraftCampaignWithHttpInfo($format, $apikey, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling creatingADraftCampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling creatingADraftCampaign');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling creatingADraftCampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/create.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\CreatingADraftCampaignResponse',
                '/campaigns/create.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\CreatingADraftCampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\CreatingADraftCampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletingACampaign
     *
     * Deleting A Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to update. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\DeletingACampaignResponse
     */
    public function deletingACampaign($format, $apikey, $campaign_id)
    {
        list($response) = $this->deletingACampaignWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation deletingACampaignWithHttpInfo
     *
     * Deleting A Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to update. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\DeletingACampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletingACampaignWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling deletingACampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling deletingACampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling deletingACampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/delete.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\DeletingACampaignResponse',
                '/campaigns/{CampaignID}/delete.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\DeletingACampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\DeletingACampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAllCampaigns
     *
     * Get All Campaigns
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetAllCampaignsResponse
     */
    public function getAllCampaigns($format, $apikey)
    {
        list($response) = $this->getAllCampaignsWithHttpInfo($format, $apikey);
        return $response;
    }

    /**
     * Operation getAllCampaignsWithHttpInfo
     *
     * Get All Campaigns
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetAllCampaignsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllCampaignsWithHttpInfo($format, $apikey)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getAllCampaigns');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getAllCampaigns');
        }
        // parse inputs
        $resourcePath = "/campaigns.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetAllCampaignsResponse',
                '/campaigns.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetAllCampaignsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetAllCampaignsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCampaignStatisticsWithPagingFiltered
     *
     * Get Campaign Statistics With Paging & Filtered
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested AB test campaign (required)
     * @param string $type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param string $page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param string $page_size The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param string $from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param string $to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetCampaignStatisticsWithPagingFilteredResponse
     */
    public function getCampaignStatisticsWithPagingFiltered($format, $apikey, $campaign_id, $type, $page = null, $page_size = null, $from = null, $to = null)
    {
        list($response) = $this->getCampaignStatisticsWithPagingFilteredWithHttpInfo($format, $apikey, $campaign_id, $type, $page, $page_size, $from, $to);
        return $response;
    }

    /**
     * Operation getCampaignStatisticsWithPagingFilteredWithHttpInfo
     *
     * Get Campaign Statistics With Paging & Filtered
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested AB test campaign (required)
     * @param string $type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param string $page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param string $page_size The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param string $from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param string $to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetCampaignStatisticsWithPagingFilteredResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCampaignStatisticsWithPagingFilteredWithHttpInfo($format, $apikey, $campaign_id, $type, $page = null, $page_size = null, $from = null, $to = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getCampaignStatisticsWithPagingFiltered');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getCampaignStatisticsWithPagingFiltered');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling getCampaignStatisticsWithPagingFiltered');
        }
        // verify the required parameter 'type' is set
        if ($type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type when calling getCampaignStatisticsWithPagingFiltered');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/stats/{Type}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($page !== null) {
            $queryParams['Page'] = $this->apiClient->getSerializer()->toQueryValue($page);
        }
        // query params
        if ($page_size !== null) {
            $queryParams['PageSize'] = $this->apiClient->getSerializer()->toQueryValue($page_size);
        }
        // query params
        if ($from !== null) {
            $queryParams['From'] = $this->apiClient->getSerializer()->toQueryValue($from);
        }
        // query params
        if ($to !== null) {
            $queryParams['To'] = $this->apiClient->getSerializer()->toQueryValue($to);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }
        // path params
        if ($type !== null) {
            $resourcePath = str_replace(
                "{" . "Type" . "}",
                $this->apiClient->getSerializer()->toPathValue($type),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetCampaignStatisticsWithPagingFilteredResponse',
                '/campaigns/{CampaignID}/stats/{Type}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetCampaignStatisticsWithPagingFilteredResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetCampaignStatisticsWithPagingFilteredResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCampaignsByPage
     *
     * Get Campaigns By Page
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page number to display results for. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetCampaignsByPageResponse
     */
    public function getCampaignsByPage($format, $apikey, $page)
    {
        list($response) = $this->getCampaignsByPageWithHttpInfo($format, $apikey, $page);
        return $response;
    }

    /**
     * Operation getCampaignsByPageWithHttpInfo
     *
     * Get Campaigns By Page
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page number to display results for. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetCampaignsByPageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCampaignsByPageWithHttpInfo($format, $apikey, $page)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getCampaignsByPage');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getCampaignsByPage');
        }
        // verify the required parameter 'page' is set
        if ($page === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page when calling getCampaignsByPage');
        }
        // parse inputs
        $resourcePath = "/campaigns/{Page}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($page !== null) {
            $resourcePath = str_replace(
                "{" . "Page" . "}",
                $this->apiClient->getSerializer()->toPathValue($page),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetCampaignsByPageResponse',
                '/campaigns/{Page}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetCampaignsByPageResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetCampaignsByPageResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCampaignsByPageAndPagesize
     *
     * Get Campaigns By Page And Pagesize
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page number to display results for. (required)
     * @param double $page_size The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GetCampaignsByPageAndPagesizeResponse
     */
    public function getCampaignsByPageAndPagesize($format, $apikey, $page, $page_size, $short_by = null, $sort_method = null)
    {
        list($response) = $this->getCampaignsByPageAndPagesizeWithHttpInfo($format, $apikey, $page, $page_size, $short_by, $sort_method);
        return $response;
    }

    /**
     * Operation getCampaignsByPageAndPagesizeWithHttpInfo
     *
     * Get Campaigns By Page And Pagesize
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param double $page The page number to display results for. (required)
     * @param double $page_size The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param string $short_by The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param string $sort_method The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GetCampaignsByPageAndPagesizeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCampaignsByPageAndPagesizeWithHttpInfo($format, $apikey, $page, $page_size, $short_by = null, $sort_method = null)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling getCampaignsByPageAndPagesize');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling getCampaignsByPageAndPagesize');
        }
        // verify the required parameter 'page' is set
        if ($page === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page when calling getCampaignsByPageAndPagesize');
        }
        // verify the required parameter 'page_size' is set
        if ($page_size === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_size when calling getCampaignsByPageAndPagesize');
        }
        // parse inputs
        $resourcePath = "/campaigns/{Page}/{PageSize}.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // query params
        if ($short_by !== null) {
            $queryParams['ShortBy'] = $this->apiClient->getSerializer()->toQueryValue($short_by);
        }
        // query params
        if ($sort_method !== null) {
            $queryParams['SortMethod'] = $this->apiClient->getSerializer()->toQueryValue($sort_method);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($page !== null) {
            $resourcePath = str_replace(
                "{" . "Page" . "}",
                $this->apiClient->getSerializer()->toPathValue($page),
                $resourcePath
            );
        }
        // path params
        if ($page_size !== null) {
            $resourcePath = str_replace(
                "{" . "PageSize" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_size),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GetCampaignsByPageAndPagesizeResponse',
                '/campaigns/{Page}/{PageSize}.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GetCampaignsByPageAndPagesizeResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GetCampaignsByPageAndPagesizeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingAllYourSenders
     *
     * Getting All Your Senders
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingAllYourSendersResponse
     */
    public function gettingAllYourSenders($format, $apikey)
    {
        list($response) = $this->gettingAllYourSendersWithHttpInfo($format, $apikey);
        return $response;
    }

    /**
     * Operation gettingAllYourSendersWithHttpInfo
     *
     * Getting All Your Senders
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingAllYourSendersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingAllYourSendersWithHttpInfo($format, $apikey)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingAllYourSenders');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingAllYourSenders');
        }
        // parse inputs
        $resourcePath = "/senders/find_all.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingAllYourSendersResponse',
                '/senders/find_all.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingAllYourSendersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingAllYourSendersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingCampaignDetails
     *
     * Getting Campaign Details
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingCampaignDetailsResponse
     */
    public function gettingCampaignDetails($format, $apikey, $campaign_id)
    {
        list($response) = $this->gettingCampaignDetailsWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation gettingCampaignDetailsWithHttpInfo
     *
     * Getting Campaign Details
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingCampaignDetailsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingCampaignDetailsWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingCampaignDetails');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingCampaignDetails');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling gettingCampaignDetails');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/view.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingCampaignDetailsResponse',
                '/campaigns/{CampaignID}/view.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingCampaignDetailsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingCampaignDetailsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation gettingSenderDetails
     *
     * Getting Sender Details
     *
     * @param string $format  (required)
     * @param string $email  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\GettingSenderDetailsResponse
     */
    public function gettingSenderDetails($format, $email, $apikey)
    {
        list($response) = $this->gettingSenderDetailsWithHttpInfo($format, $email, $apikey);
        return $response;
    }

    /**
     * Operation gettingSenderDetailsWithHttpInfo
     *
     * Getting Sender Details
     *
     * @param string $format  (required)
     * @param string $email  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\GettingSenderDetailsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function gettingSenderDetailsWithHttpInfo($format, $email, $apikey)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling gettingSenderDetails');
        }
        // verify the required parameter 'email' is set
        if ($email === null) {
            throw new \InvalidArgumentException('Missing the required parameter $email when calling gettingSenderDetails');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling gettingSenderDetails');
        }
        // parse inputs
        $resourcePath = "/senders/find_one.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($email !== null) {
            $queryParams['Email'] = $this->apiClient->getSerializer()->toQueryValue($email);
        }
        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\GettingSenderDetailsResponse',
                '/senders/find_one.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\GettingSenderDetailsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\GettingSenderDetailsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation linkActivity
     *
     * Link Activity
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\LinkActivityResponse
     */
    public function linkActivity($format, $apikey, $campaign_id)
    {
        list($response) = $this->linkActivityWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation linkActivityWithHttpInfo
     *
     * Link Activity
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the requested campaign (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\LinkActivityResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function linkActivityWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling linkActivity');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling linkActivity');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling linkActivity');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/stats/links.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\LinkActivityResponse',
                '/campaigns/{CampaignID}/stats/links.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\LinkActivityResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\LinkActivityResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation schedulingACampaign
     *
     * Scheduling A Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the campaign to be scheduled (required)
     * @param \Swagger\Client\Model\SchedulingACampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\SchedulingACampaignResponse
     */
    public function schedulingACampaign($format, $apikey, $campaign_id, $body)
    {
        list($response) = $this->schedulingACampaignWithHttpInfo($format, $apikey, $campaign_id, $body);
        return $response;
    }

    /**
     * Operation schedulingACampaignWithHttpInfo
     *
     * Scheduling A Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the campaign to be scheduled (required)
     * @param \Swagger\Client\Model\SchedulingACampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\SchedulingACampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function schedulingACampaignWithHttpInfo($format, $apikey, $campaign_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling schedulingACampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling schedulingACampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling schedulingACampaign');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling schedulingACampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/schedule.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\SchedulingACampaignResponse',
                '/campaigns/{CampaignID}/schedule.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\SchedulingACampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\SchedulingACampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation sendingACampaign
     *
     * Sending a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to be sent. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\SendingACampaignResponse
     */
    public function sendingACampaign($format, $apikey, $campaign_id)
    {
        list($response) = $this->sendingACampaignWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation sendingACampaignWithHttpInfo
     *
     * Sending a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to be sent. (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\SendingACampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendingACampaignWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling sendingACampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling sendingACampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling sendingACampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/send.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\SendingACampaignResponse',
                '/campaigns/{CampaignID}/send.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\SendingACampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\SendingACampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation testingACampaign
     *
     * Testing a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to be tested. (required)
     * @param \Swagger\Client\Model\TestingACampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\TestingACampaignResponse
     */
    public function testingACampaign($format, $apikey, $campaign_id, $body)
    {
        list($response) = $this->testingACampaignWithHttpInfo($format, $apikey, $campaign_id, $body);
        return $response;
    }

    /**
     * Operation testingACampaignWithHttpInfo
     *
     * Testing a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to be tested. (required)
     * @param \Swagger\Client\Model\TestingACampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\TestingACampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function testingACampaignWithHttpInfo($format, $apikey, $campaign_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling testingACampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling testingACampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling testingACampaign');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling testingACampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/send_test.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\TestingACampaignResponse',
                '/campaigns/{CampaignID}/send_test.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\TestingACampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\TestingACampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation unschedulingACampaign
     *
     * Unscheduling a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the campaign to be scheduled (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UnschedulingACampaignResponse
     */
    public function unschedulingACampaign($format, $apikey, $campaign_id)
    {
        list($response) = $this->unschedulingACampaignWithHttpInfo($format, $apikey, $campaign_id);
        return $response;
    }

    /**
     * Operation unschedulingACampaignWithHttpInfo
     *
     * Unscheduling a campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the campaign to be scheduled (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UnschedulingACampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function unschedulingACampaignWithHttpInfo($format, $apikey, $campaign_id)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling unschedulingACampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling unschedulingACampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling unschedulingACampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/unschedule.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UnschedulingACampaignResponse',
                '/campaigns/{CampaignID}/unschedule.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UnschedulingACampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UnschedulingACampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatingADraftCampaign
     *
     * Updating A Draft Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to update. (required)
     * @param \Swagger\Client\Model\UpdatingADraftCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return \Swagger\Client\Model\UpdatingADraftCampaignResponse
     */
    public function updatingADraftCampaign($format, $apikey, $campaign_id, $body)
    {
        list($response) = $this->updatingADraftCampaignWithHttpInfo($format, $apikey, $campaign_id, $body);
        return $response;
    }

    /**
     * Operation updatingADraftCampaignWithHttpInfo
     *
     * Updating A Draft Campaign
     *
     * @param string $format  (required)
     * @param string $apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param string $campaign_id The ID of the draft campaign to update. (required)
     * @param \Swagger\Client\Model\UpdatingADraftCampaignRequest $body  (required)
     * @throws \Swagger\Client\ApiException on non-2xx response
     * @return array of \Swagger\Client\Model\UpdatingADraftCampaignResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatingADraftCampaignWithHttpInfo($format, $apikey, $campaign_id, $body)
    {
        // verify the required parameter 'format' is set
        if ($format === null) {
            throw new \InvalidArgumentException('Missing the required parameter $format when calling updatingADraftCampaign');
        }
        // verify the required parameter 'apikey' is set
        if ($apikey === null) {
            throw new \InvalidArgumentException('Missing the required parameter $apikey when calling updatingADraftCampaign');
        }
        // verify the required parameter 'campaign_id' is set
        if ($campaign_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $campaign_id when calling updatingADraftCampaign');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updatingADraftCampaign');
        }
        // parse inputs
        $resourcePath = "/campaigns/{CampaignID}/update.{Format}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        if ($apikey !== null) {
            $queryParams['apikey'] = $this->apiClient->getSerializer()->toQueryValue($apikey);
        }
        // path params
        if ($format !== null) {
            $resourcePath = str_replace(
                "{" . "Format" . "}",
                $this->apiClient->getSerializer()->toPathValue($format),
                $resourcePath
            );
        }
        // path params
        if ($campaign_id !== null) {
            $resourcePath = str_replace(
                "{" . "CampaignID" . "}",
                $this->apiClient->getSerializer()->toPathValue($campaign_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Swagger\Client\Model\UpdatingADraftCampaignResponse',
                '/campaigns/{CampaignID}/update.{Format}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Swagger\Client\Model\UpdatingADraftCampaignResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Swagger\Client\Model\UpdatingADraftCampaignResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
